/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.editor.Problem;
import java.util.Collection;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_COL = 0;
    public static final int NUM_COL = 1;
    public static final int ERRCODE_COL = 2;
    public static final int DESCR_COL = 3;
    private static final String[] colNames = new String[]{" ", " # ", "Error #", "Description"};
    private Vector<Problem> m_problems = new Vector();

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public int getRowCount() {
        return this.m_problems.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.m_problems.size()) {
            return null;
        }
        String string = " ";
        Problem problem = this.getProblem(n);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                string = problem.getDescription();
            }
        }
        return string;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    public void setProblems(Collection<Problem> collection) {
        this.clear();
        for (Problem problem : collection) {
            this.m_problems.add(problem);
        }
        if (this.m_problems.size() > 0) {
            this.fireTableRowsInserted(0, this.m_problems.size() - 1);
        }
    }

    public void addProblem(Problem problem) {
        this.m_problems.add(problem);
        int n = this.m_problems.size() - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void clear() {
        int n = this.m_problems.size();
        if (n > 0) {
            this.m_problems.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public Problem getProblem(int n) {
        if (n >= this.m_problems.size()) {
            return null;
        }
        return this.m_problems.get(n);
    }
}

